DROP PROCEDURE [hips].[ClinicalDocumentUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 13 March 2012
-- Description:   Updates a record in the ClinicalDocument Table
-- 08/10/2012 - gmassey - change the Pcehr table to ClinicalDocument
-- 06/12/2012 - sbiber - Added status and removal information
-- 16/06/2013 - sbiber - Changed set ID length from 50 to 128
-- =============================================
CREATE PROCEDURE [hips].[ClinicalDocumentUpdate] 
(
	  @ClinicalDocumentId INT
	, @SourceSystemSetId VARCHAR(128)
	, @EpisodeId INT
	, @DocumentTypeId INT
	, @RemovalReasonId INT
	, @RemovedDate DATETIME = NULL
	, @ClinicalDocumentStatusId INT
	, @UserModified varchar(256)
	, @DateModified datetime
) AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[ClinicalDocument]
				WHERE [ClinicalDocumentId] = @ClinicalDocumentId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN

UPDATE hips.ClinicalDocument
SET
		SourceSystemSetId = @SourceSystemSetId,
		EpisodeId = @EpisodeId,
		DocumentTypeId = @DocumentTypeId,
		[RemovalReasonId] = @RemovalReasonId,
		[RemovedDate] = @RemovedDate,
		[ClinicalDocumentStatusId] = @ClinicalDocumentStatusId,
		[DateModified] = GetDate(),
        [UserModified] = @UserModified
WHERE   ClinicalDocumentId = @ClinicalDocumentId
        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
        SELECT [ClinicalDocumentId],
                SourceSystemSetId,
                EpisodeId,
                cd.DocumentTypeId,
				dt.Description as DocumentTypeDescription,
				dt.Code as DocumentTypeCode,
				cd.RemovalReasonId,
				rr.Description as RemovalReasonDescription,
				cd.RemovedDate,
				cd.ClinicalDocumentStatusId,
                cd.[DateCreated],
                cd.[UserCreated],
                cd.[DateModified],
                cd.[UserModified]
		FROM [hips].[ClinicalDocument] cd
		INNER JOIN hips.DocumentType As dt on dt.DocumentTypeId = cd.DocumentTypeId
		INNER JOIN hips.RemovalReason AS rr ON cd.RemovalReasonId = rr.RemovalReasonId
		WHERE [ClinicalDocumentId] = @ClinicalDocumentId
    END

    RETURN(@intErrorCode)


END
GO

